<?php
session_start();
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT id, password, is_admin FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && $user['is_admin'] && password_verify($password, $user['password'])) {
        $_SESSION['admin_id'] = $user['id'];
        $_SESSION['is_admin'] = true;
        header("Location: index.php");
        exit;
    } else {
        $error = "Invalid credentials or not admin.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Ninja Hope</title>
    <style>
        body{font-family:Arial;background:#f4f4f4;display:flex;align-items:center;justify-content:center;height:100vh;margin:0;}
        .login-box{background:#fff;padding:2rem;border-radius:16px;box-shadow:0 0 20px rgba(0,0,0,.1);width:100%;max-width:400px;}
        input{padding:12px;margin:10px 0;width:100%;border:1px solid #ddd;border-radius:8px;font-size:1rem;}
        button{padding:12px;background:#28a745;color:#fff;border:none;width:100%;border-radius:8px;font-size:1rem;cursor:pointer;}
        .error{color:#dc3545;margin:10px 0;text-align:center;}
    </style>
</head>
<body>
<div class="login-box">
    <h2 style="text-align:center;color:#28a745;">Admin Login</h2>
    <?php if (isset($error)): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
        <input type="text" name="username" placeholder="Username" required>
        <input type="password" name="password" placeholder="Password" required>
        <button type="submit">Login</button>
    </form>
    <p style="text-align:center;margin-top:1rem;font-size:0.9rem;color:#666;">
        Default: <strong>admin</strong> / <strong>admin123</strong>
    </p>
</div>
</body>
</html>