<?php
require_once '../config.php';
session_start();
if (empty($_SESSION['is_admin'])) { header("Location: ../login.php"); exit; }

// Approve / Reject
if (isset($_GET['action']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $action = $_GET['action']; // approve or reject
    $status = ($action === 'approve') ? 'approved' : 'rejected';

    $stmt = $pdo->prepare("UPDATE user_tasks SET status = ?, reviewed_at = NOW() WHERE id = ?");
    $stmt->execute([$status, $id]);

    if ($action === 'approve') {
        $ut = $pdo->query("SELECT user_id, task_id FROM user_tasks WHERE id = $id")->fetch();
        $task = $pdo->query("SELECT reward FROM tasks WHERE id = {$ut['task_id']}")->fetch();
        $pdo->prepare("UPDATE user_wallets SET daily_cashback = daily_cashback + ? WHERE user_id = ?")
            ->execute([$task['reward'], $ut['user_id']]);
    }
}

$pending = $pdo->query("
    SELECT ut.*, u.username, t.title, t.reward 
    FROM user_tasks ut
    JOIN users u ON ut.user_id = u.id
    JOIN tasks t ON ut.task_id = t.id
    WHERE ut.status = 'pending'
    ORDER BY ut.submitted_at DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html><head><title>Pending Tasks</title><style>
    body{font-family:Arial;background:#f4f4f4;padding:2rem;}
    .box{background:#fff;padding:2rem;border-radius:16px;box-shadow:0 0 15px rgba(0,0,0,.1);max-width:1000px;margin:auto;}
    table{width:100%;border-collapse:collapse;}
    th,td{border:1px solid #ddd;padding:10px;text-align:left;}
    th{background:#28a745;color:white;}
    img{max-width:150px;border-radius:8px;}
    .btn{padding:8px 12px;margin:0 5px;border:none;border-radius:8px;color:white;cursor:pointer;}
    .approve{background:#28a745;}
    .reject{background:#dc3545;}
</style></head><body>
<div class="box">
    <h2>Pending Task Submissions</h2>
    <table>
        <tr><th>User</th><th>Task</th><th>Reward</th><th>Screenshot</th><th>Action</th></tr>
        <?php foreach ($pending as $p): ?>
        <tr>
            <td><?= htmlspecialchars($p['username']) ?></td>
            <td><?= htmlspecialchars($p['title']) ?></td>
            <td>₦<?= $p['reward'] ?></td>
            <td><img src="../uploads/tasks/<?= $p['screenshot'] ?>" alt="Proof"></td>
            <td>
                <a href="?action=approve&id=<?= $p['id'] ?>" class="btn approve">Approve</a>
                <a href="?action=reject&id=<?= $p['id'] ?>" class="btn reject">Reject</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body></html>