<?php
session_start();
require_once '../config.php';
if (empty($_SESSION['is_admin'])) { header("Location: login.php"); exit; }

// Approve / Reject
if (isset($_GET['action']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $status = ($_GET['action'] === 'approve') ? 'approved' : 'rejected';
    $pdo->prepare("UPDATE users SET face_status = ? WHERE id = ?")->execute([$status, $id]);
}

$pending = $pdo->query("
    SELECT id, username, face_image, verification_code 
    FROM users 
    WHERE face_status = 'pending' AND face_image IS NOT NULL
    ORDER BY id DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html><head><title>Verify Images</title>
<style>
    body{font-family:Arial;background:#f4f4f4;padding:2rem;}
    .box{background:#fff;padding:2rem;border-radius:16px;box-shadow:0 0 15px rgba(0,0,0,.1);max-width:900px;margin:auto;}
    table{width:100%;border-collapse:collapse;margin-top:1rem;}
    th,td{border:1px solid #ddd;padding:10px;text-align:center;}
    th{background:#28a745;color:white;}
    img{max-width:120px;border-radius:8px;}
    .btn{padding:8px 12px;margin:0 5px;border:none;border-radius:8px;color:white;cursor:pointer;}
    .approve{background:#28a745;}
    .reject{background:#dc3545;}
    .code{font-family:monospace;font-weight:bold;color:#28a745;}
</style>
</head><body>
<div class="box">
    <h2>Pending Face Verifications</h2>
    <table>
        <tr><th>User</th><th>Code</th><th>Image</th><th>Action</th></tr>
        <?php foreach ($pending as $p): ?>
        <tr>
            <td><?= htmlspecialchars($p['username']) ?></td>
            <td class="code"><?= $p['verification_code'] ?></td>
            <td><img src="../uploads/face/<?= $p['face_image'] ?>" alt="Face"></td>
            <td>
                <a href="?action=approve&id=<?= $p['id'] ?>" class="btn approve">Approve</a>
                <a href="?action=reject&id=<?= $p['id'] ?>" class="btn reject">Reject</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
    <?php if (empty($pending)): ?><p style="text-align:center;color:#666;padding:2rem;">No pending verifications.</p><?php endif; ?>
</div>
</body></html>