<?php
require_once '../config.php';
session_start();
if (empty($_SESSION['is_admin'])) { header("Location: ../login.php"); exit; }

// Assume you have a withdrawals table
// CREATE TABLE withdrawals (id INT AUTO_INCREMENT PRIMARY KEY, user_id INT, amount DECIMAL(10,2), balance_type VARCHAR(20), status ENUM('pending','approved','rejected'), created_at DATETIME);

if (isset($_GET['action']) && isset($_GET['id'])) {
    $status = ($_GET['action'] === 'approve') ? 'approved' : 'rejected';
    $pdo->prepare("UPDATE withdrawals SET status = ? WHERE id = ?")->execute([$status, $_GET['id']]);
}

$withdrawals = $pdo->query("
    SELECT w.*, u.username 
    FROM withdrawals w 
    JOIN users u ON w.user_id = u.id 
    WHERE w.status = 'pending'
")->fetchAll();
?>
<!DOCTYPE html>
<html><head><title>Withdrawals</title><style>
    body{font-family:Arial;background:#f4f4f4;padding:2rem;}
    table{width:100%;border-collapse:collapse;}
    th,td{border:1px solid #ddd;padding:10px;}
    th{background:#28a745;color:white;}
    .btn{padding:6px 10px;margin:0 3px;border:none;border-radius:6px;color:white;}
    .approve{background:#28a745;}
    .reject{background:#dc3545;}
</style></head><body>
<div style="max-width:900px;margin:auto;background:#fff;padding:2rem;border-radius:16px;">
    <h2>Pending Withdrawals</h2>
    <table>
        <tr><th>User</th><th>Amount</th><th>From</th><th>Action</th></tr>
        <?php foreach ($withdrawals as $w): ?>
        <tr>
            <td><?= $w['username'] ?></td>
            <td>₦<?= $w['amount'] ?></td>
            <td><?= ucfirst(str_replace('_', ' ', $w['balance_type'])) ?></td>
            <td>
                <a href="?action=approve&id=<?= $w['id'] ?>" class="btn approve">Approve</a>
                <a href="?action=reject&id=<?= $w['id'] ?>" class="btn reject">Reject</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body></html>